/**********************************************************************/
/*                         E D I T . H                                */
/**------------------------------------------------------------------**/
/*  Task            : Include file for Edit                           */
/**------------------------------------------------------------------**/
/*  Author       : Michael Tischer / Bruno Ferrari                    */
/*  Developed on : 5/3/94                                             */
/*  Last update  : 5/15/94                                            */
/**********************************************************************/
#ifndef _INC_EDIT_H
#define _INC_EDIT_H

#include "win.h"

#define EDIT_DISPLAY 0x0001          /* Editor only  used for display */
#define EDIT_NOCR    0x0002           /* Editor does not accept ENTER */

typedef struct tagEDIT
{
  WINDOW  Win;          /* Window displayed in the line of the Editor */
  LPBYTE  lpBuffer;                                   /* Input Buffer */
  UINT    uFlags;                                      /* s. EDIT_??? */

  int     iUsed,           /* Number of characters in the text buffer */
          iSize;                       /* Maximum size of text buffer */

  int     iEditPos;                          /* Current edit position */
  int     iEditRow;                               /* Current edit row */
  int     iLeftOffset;                      /* First displayed column */

  int     iRowStarts[ 26 ];                        /* Maximum 25 rows */
} EDIT;  
typedef EDIT _far *LPEDIT;

#define CTL_TEXT 0
#define CTL_EDIT 1

typedef struct tagCONTROL
{
  int iX, iY, iW, iH, iA;/* Position, dimension, attribute of control */
  LPCHAR lpText;                                /* Heading of control */
  LPBYTE lpBuffer;                          /* Buffer if Edit control */
  UINT   uBufSize;                     /* Buffer size if Edit control */
  UINT   uFlags;                             /* Flags if Edit control */
  BYTE   bType;                                    /* Type of control */
  LPVOID lpAdditional;                    /* Address of actual object */
} CONTROL;
typedef CONTROL far *LPCONTROL;

#endif

